package gov.va.vinci.dart.json.builder;

import java.util.List;

import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;

import gov.va.vinci.dart.biz.Person;
import gov.va.vinci.dart.biz.RequestSummary;
import gov.va.vinci.dart.json.RequestListView;
import gov.va.vinci.dart.json.RequestView;

@Component
public class RequestListViewBuilder {
	@Autowired
	private RequestViewBuilder requestViewBuilder;

	
	/**
	 * Used by the RequestResource (REST) when retrieving all requests.
	 * @param requestList
	 * @param bIncludeLinks
	 * @return
	 */
	public RequestListView build(final List<RequestSummary> requestList, final boolean bIncludeLinks) {
		RequestListView result = new RequestListView();

		for (RequestSummary summary : requestList) {
			RequestView view = requestViewBuilder.buildRequestorTab(summary, bIncludeLinks);
			result.getRequests().add(view);
		}
		return result;
	}


	/**
	 * Used by the RequestResource (REST) when retrieving requests for a specific participant.
	 * @param requestList
	 * @param bIncludeLinks
	 * @return
	 */
	public RequestListView build(final List<RequestSummary> requestList, final Person person, final boolean bIncludeLinks) {
		RequestListView result = new RequestListView();

		for (RequestSummary summary : requestList) {
			RequestView view = requestViewBuilder.buildRequestorTab(summary, person, bIncludeLinks);
			result.getRequests().add(view);
		}
		return result;
	}

}
